#ifndef MATERIAL_H
#define MATERIAL_H

#include "piece.h"
#include "squares.h"
#include "defs.h"
#include "utils.h"


const uint PAWNBASE = 256;
const uint PAWN16TH = PAWNBASE/16;
const uint vE = 0;
const uint vP = PAWNBASE;
const uint vN = 3 * PAWNBASE + 2 * PAWN16TH;
const uint vB = 3 * PAWNBASE + 4 * PAWN16TH;
const uint vR = 5 * PAWNBASE;
const uint vQ = 9 * PAWNBASE;
const uint vK = 50*vQ * PAWNBASE;

const uint ENDMAT = 4*vR + vB + vN + 4*vP;

const uint piecevals[numpieces] = {vE, vP, vP, vN, vN, vB, vB, vR, vR, vQ, vQ, vK, vK};

class cMaterial {

private:


    cMaterial( const cMaterial & );
    cMaterial &operator = ( const cMaterial & );


//piece list
uint pcelist[numpieces][maxpiecenum];
uint pcecount[numpieces];

//counters (pawns counted above in pcecount)
uint majors[numcolours];
uint minors[numcolours];
uint bigpieces[numcolours];

uint material[numcolours];
int psqvalope[numcolours];
int psqvalend[numcolours];

//psq tables
static int psqt[numpieces][2][BRDSQ];

//pawn bitboards
u64 pawnbrds[3];//pwP==1 pbP==2

public:

cMaterial();
void clearpcelists();
void setpiecelists(const uint *board);
void printmaterial();

uint &getpcesq(const uint &type, const uint &num){ASS(piecegood(type)); ASS(num<maxpiecenum); return pcelist[type][num];}//return sq uint is on
const uint &getpcenum(const uint &type){ ASS(piecegood(type)); return pcecount[type];} //return num uints of type "type"
const uint &getmaterial(const uint side){ ASS(colourgood(side)); return material[side]; }
const uint &getmajors(const uint side){ ASS(colourgood(side)); return majors[side]; }
const uint &getminors(const uint side){ ASS(colourgood(side)); return minors[side]; }
const uint &getbigpieces(const uint side){ ASS(colourgood(side)); return bigpieces[side]; }
uint getkingsq(uint side) { ASS(side==cW||side==cB); return pcelist[kings[side]][1]; }

u64 &getboard(const uint pce) { ASS(pce==pwP || pce==pbP); return pawnbrds[pce]; }

void movepsqt(uint pce, uint from, uint to);
void removepsqt(uint pce, uint sq);
void addpsqt(uint pce, uint sq);
int getpsqt(uint phase, uint pce, uint sq)
{
     ASS(piecegood(pce)); ASS(phase==OPE||phase==END);ASS(onbrd(sq));
     return psqt[pce][phase][sq];
}
int getpsqvalope() { return psqvalope[cW]-psqvalope[cB]; }
int getpsqvalend() { return psqvalend[cW]-psqvalend[cB]; }

bool drawmaterial();

uint *p2list(uint &pce) {return pcelist[pce];}

static void init_psqt();

//piece list add / remove / edit
void addpiece(const uint &pce, const uint &sq);
void removepiece(const uint &pce, const uint &sq);
void movepiece(const uint &pce, const uint &sqfrom, const uint &sqto);

};


#endif
